'use client';

import { Button } from './ui/button';
import { Mail } from 'lucide-react';
import Link from 'next/link';

export function FloatingCta() {
  return (
    <div className="fixed bottom-6 right-6 z-50">
      <Button asChild size="icon" className="h-14 w-14 rounded-full bg-accent shadow-lg hover:bg-accent/90">
        <Link href="/contact">
          <Mail className="h-7 w-7" />
          <span className="sr-only">Contact Us</span>
        </Link>
      </Button>
    </div>
  );
}
